package data.scripts;

import com.fs.starfarer.api.BaseModPlugin;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.PluginPick;
import com.fs.starfarer.api.campaign.CampaignFleetAPI;
import com.fs.starfarer.api.campaign.CampaignPlugin;
import com.fs.starfarer.api.campaign.CampaignPlugin.PickPriority;
import com.fs.starfarer.api.campaign.FactionAPI;
import com.fs.starfarer.api.campaign.RepLevel;
import com.fs.starfarer.api.campaign.SectorAPI;
import com.fs.starfarer.api.combat.AutofireAIPlugin;
import com.fs.starfarer.api.combat.MissileAIPlugin;
import com.fs.starfarer.api.combat.MissileAPI;
import com.fs.starfarer.api.combat.ShipAIConfig;
import com.fs.starfarer.api.combat.ShipAIPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.fleet.FleetMemberAPI;
import com.fs.starfarer.api.impl.campaign.ids.Factions;
import com.fs.starfarer.api.impl.campaign.ids.HullMods;
import com.fs.starfarer.api.impl.campaign.ids.Personalities;
import com.thoughtworks.xstream.XStream;
import data.scripts.campaign.events.SWP_EventStarter;
import data.scripts.campaign.events.SWP_IBBTracker;
import data.scripts.campaign.missions.SWP_FamousBountyEvent;
import data.scripts.campaign.missions.SWP_FamousBountyMission;
import data.scripts.everyframe.SWP_BlockedHullmodDisplayScript;
import data.scripts.hullmods.SWP_MaximizedOrdinance;
import data.scripts.shaders.SWP_OmegaDriveShader;
import data.scripts.weapons.ai.SWP_EMPBombWeaponAI;
import data.scripts.weapons.ai.SWP_FlareBurstAI;
import data.scripts.weapons.ai.SWP_FlareBurstWeaponAI;
import data.scripts.weapons.ai.SWP_FlareGunWeaponAI;
import data.scripts.weapons.ai.SWP_GodModeWeaponAI;
import data.scripts.weapons.ai.SWP_HornetAI;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Level;
import org.dark.shaders.light.LightData;
import org.dark.shaders.util.ShaderLib;
import org.dark.shaders.util.TextureData;
import org.json.JSONException;
import org.json.JSONObject;

public class SWPModPlugin extends BaseModPlugin {

    public static final String EMPBOMB_ID = "empbomb";
    public static final String FLAREBURST_ID = "ssp_flareburst";
    public static final String FLAREBURST_MRM_ID = "swp_flareburst_mrm";
    public static final String FLAREGUN_ID = "ssp_flaregun";
    public static final String GODMODE_ID = "godmode";
    public static final String HORNET_MRM_ID = "swp_hornet_mrm";

    public static boolean Module_FamousBounties = true;

    public static boolean Param_LegacyIBB = true;

    public static boolean blackrockExists = false;
    public static boolean checkMemory = false;
    public static boolean citadelExists = false;
    public static boolean diableExists = false;
    public static boolean exigencyExists = false;
    public static boolean hasDynaSector = false;
    public static boolean hasGraphicsLib = false;
    public static boolean hasUnderworld = false;
    public static boolean imperiumExists = false;
    public static boolean isExerelin = false;
    public static boolean junkPiratesExists = false;
    public static boolean mayorateExists = false;
    public static boolean oraExists = false;
    public static boolean scyExists = false;
    public static boolean shadowyardsExists = false;
    public static boolean templarsExists = false;
    public static boolean tiandongExists = false;
    public static boolean tyradorExists = false;
    public static boolean dmeExists = false;

    private static final String SETTINGS_FILE = "SWP_OPTIONS.ini";

    public static void syncSWPScripts() {
        if (!Global.getSector().hasScript(SWP_EventStarter.class)) {
            SWP_EventStarter eventStarter = new SWP_EventStarter();
            Global.getSector().addScript(eventStarter);
        }
        if (!Global.getSector().hasScript(SWP_IBBTracker.class)) {
            SWP_IBBTracker ibbTracker = new SWP_IBBTracker();
            Global.getSector().addScript(ibbTracker);
        }
    }

    public static void syncSWPScriptsExerelin() {
        if (!Global.getSector().hasScript(SWP_EventStarter.class)) {
            SWP_EventStarter eventStarter = new SWP_EventStarter();
            Global.getSector().addScript(eventStarter);
        }
        if (!Global.getSector().hasScript(SWP_IBBTracker.class)) {
            SWP_IBBTracker ibbTracker = new SWP_IBBTracker();
            Global.getSector().addScript(ibbTracker);
        }
    }

    private static void initGraphicsLib() {
        ShaderLib.init();

        if (ShaderLib.areShadersAllowed() && ShaderLib.areBuffersAllowed()) {
            LightData.readLightDataCSV("data/lights/swp_light_data.csv");
            TextureData.readTextureDataCSV("data/lights/swp_texture_data.csv");
            ShaderLib.addShaderAPI(new SWP_OmegaDriveShader());
        }
    }

    private static void loadSettings() throws IOException, JSONException {
        JSONObject settings = Global.getSettings().loadJSON(SETTINGS_FILE);

        Param_LegacyIBB = settings.getBoolean("legacyIBB");

        Module_FamousBounties = settings.getBoolean("famousBounties");
    }

    @Override
    public void configureXStream(XStream x) {
        x.alias("SWP_EventStarter", SWP_EventStarter.class);
        x.alias("SWP_FamousBountyEvent", SWP_FamousBountyEvent.class);
        x.alias("SWP_FamousBountyMission", SWP_FamousBountyMission.class);
        x.alias("SWP_IBBTracker", SWP_IBBTracker.class);
    }

    @Override
    public void onApplicationLoad() throws Exception {
        boolean hasLazyLib = Global.getSettings().getModManager().isModEnabled("lw_lazylib");
        if (!hasLazyLib) {
            throw new RuntimeException("Ship/Weapon Pack requires LazyLib by LazyWizard!");
        }
        boolean hasLionsGuard = Global.getSettings().getModManager().isModEnabled("Lions Guard");
        if (hasLionsGuard) {
            throw new RuntimeException("Ship/Weapon Pack is incompatible with The Lion's Guard by King Alfonzo");
        }
        hasGraphicsLib = Global.getSettings().getModManager().isModEnabled("shaderLib");
        if (!hasGraphicsLib) {
            throw new RuntimeException("Ship/Weapon Pack requires GraphicsLib by DarkRevenant!");
        } else {
            initGraphicsLib();
        }

        try {
            loadSettings();
        } catch (IOException | JSONException e) {
            Global.getLogger(SWPModPlugin.class).log(Level.ERROR, "Settings loading failed! " + e.getMessage());
        }

        isExerelin = Global.getSettings().getModManager().isModEnabled("nexerelin");
        hasUnderworld = Global.getSettings().getModManager().isModEnabled("underworld");
        hasDynaSector = Global.getSettings().getModManager().isModEnabled("dynasector");

        if (Global.getSettings().getModManager().isModEnabled("dr_ssp")) {
            String[] verString = Global.getSettings().getModManager().getModSpec("dr_ssp").getVersion().split("\\.");
            int major = Integer.parseInt(verString[0]);
            int minor = Integer.parseInt(verString[1]);
            if (major <= 3 && minor < 8) {
                throw new RuntimeException("Ship/Weapon Pack is not compatible with Starsector+");
            }
        }

        imperiumExists = Global.getSettings().getModManager().isModEnabled("Imperium");
        templarsExists = Global.getSettings().getModManager().isModEnabled("Templars");
        blackrockExists = Global.getSettings().getModManager().isModEnabled("blackrock_driveyards");
        exigencyExists = Global.getSettings().getModManager().isModEnabled("exigency");
        citadelExists = Global.getSettings().getModManager().isModEnabled("Citadel");
        shadowyardsExists = Global.getSettings().getModManager().isModEnabled("shadow_ships");
        mayorateExists = Global.getSettings().getModManager().isModEnabled("mayorate");
        junkPiratesExists = Global.getSettings().getModManager().isModEnabled("junk_pirates_release");
        scyExists = Global.getSettings().getModManager().isModEnabled("SCY");
        tiandongExists = Global.getSettings().getModManager().isModEnabled("THI");
        diableExists = Global.getSettings().getModManager().isModEnabled("diableavionics");
        oraExists = Global.getSettings().getModManager().isModEnabled("ORA");
        tyradorExists = Global.getSettings().getModManager().isModEnabled("TS_Coalition");
        dmeExists = Global.getSettings().getModManager().isModEnabled("istl_dam");
    }

    @Override
    public void onGameLoad(boolean newGame) {
        Global.getSector().addTransientScript(new SWP_BlockedHullmodDisplayScript());

        if (isExerelin) {
            syncSWPScriptsExerelin();
        } else {
            syncSWPScripts();
        }

        SWP_IBBTracker ibbTracker = SWP_IBBTracker.getTracker();
        ibbTracker.refresh();

        CampaignFleetAPI player = Global.getSector().getPlayerFleet();
        if (player != null) {
            for (FleetMemberAPI member : player.getFleetData().getMembersListCopy()) {
                if (member.getVariant().hasHullMod("maximized_ordinance")) {
                    SWP_MaximizedOrdinance.addMember(member);
                }
            }
        }
    }

    @Override
    public void onNewGame() {
        if (isExerelin) {
            syncSWPScriptsExerelin();
        } else {
            syncSWPScripts();
        }
    }

    @Override
    public void onNewGameAfterTimePass() {
        SectorAPI sector = Global.getSector();
        FactionAPI player = sector.getFaction(Factions.PLAYER);
        for (FactionAPI faction : Global.getSector().getAllFactions()) {
            if (faction != player) {
                faction.setRelationship("famous_bounty", RepLevel.NEUTRAL);
            }
        }
        player.setRelationship("famous_bounty", -1f);
    }

    @Override
    public PluginPick<MissileAIPlugin> pickMissileAI(MissileAPI missile, ShipAPI launchingShip) {
        if (HORNET_MRM_ID.contentEquals(missile.getProjectileSpecId())) {
            return new PluginPick<MissileAIPlugin>(new SWP_HornetAI(missile, launchingShip),
                    CampaignPlugin.PickPriority.MOD_SET);
        }
        if (FLAREBURST_MRM_ID.contentEquals(missile.getProjectileSpecId())) {
            return new PluginPick<MissileAIPlugin>(new SWP_FlareBurstAI(missile, launchingShip),
                    CampaignPlugin.PickPriority.MOD_SET);
        }
        return null;
    }

    @Override
    public PluginPick<ShipAIPlugin> pickShipAI(FleetMemberAPI member, ShipAPI ship) {

        Set<String> derelicts = new HashSet<>(3);
        derelicts.add("swp_wall");
        derelicts.add("swp_wall_left");
        derelicts.add("swp_wall_right");

        String hullId = ship.getHullSpec().getHullId();
        if (!derelicts.contains(hullId) && !ship.getVariant().hasHullMod(HullMods.AUTOMATED)) {
            return null;
        }

        //HullSize size = ship.getHullSize();
        ShipAIConfig config = new ShipAIConfig();
        config.alwaysStrafeOffensively = true;
        config.backingOffWhileNotVentingAllowed = false;
        config.turnToFaceWithUndamagedArmor = false;
        config.burnDriveIgnoreEnemies = true;
        config.personalityOverride = Personalities.RECKLESS;

        return new PluginPick<>(Global.getSettings().createDefaultShipAI(ship, config),
                PickPriority.MOD_SET);
    }

    @Override
    public PluginPick<AutofireAIPlugin> pickWeaponAutofireAI(WeaponAPI weapon) {
        if (FLAREGUN_ID.contentEquals(weapon.getId())) {
            return new PluginPick<AutofireAIPlugin>(new SWP_FlareGunWeaponAI(weapon),
                    CampaignPlugin.PickPriority.MOD_SET);
        }
        if (FLAREBURST_ID.contentEquals(weapon.getId())) {
            return new PluginPick<AutofireAIPlugin>(new SWP_FlareBurstWeaponAI(weapon),
                    CampaignPlugin.PickPriority.MOD_SET);
        }
        if (GODMODE_ID.contentEquals(weapon.getId())) {
            return new PluginPick<AutofireAIPlugin>(new SWP_GodModeWeaponAI(weapon), CampaignPlugin.PickPriority.MOD_SET);
        }
        if (EMPBOMB_ID.contentEquals(weapon.getId())) {
            return new PluginPick<AutofireAIPlugin>(new SWP_EMPBombWeaponAI(weapon), CampaignPlugin.PickPriority.MOD_SET);
        }
        return null;
    }
}
